#include <avr/io.h>
#include <avr/pgmspace.h>
  
#define F_CPU 20000000
#include <util/delay.h>

#include "LCDLIB.h"

void LcdEStrobe(){
// timings for 16MHz=62.5ns cycle time

  _delay_loop_1(1) ; // Setup time 40ns
  LCD_E_PORT |=   (1 << LCD_E_BIT) ;
  _delay_loop_1(1) ; // Setup time 220ns
  LCD_E_PORT &= ~ (1 << LCD_E_BIT) ;
  _delay_loop_1(1) ; // stretch to cycle time
  }

void LcdWriteByte(uint8_t b){
  LCD_DB4_DDR |= (1 << LCD_DB4_BIT) ; 
  LCD_DB5_DDR |= (1 << LCD_DB5_BIT) ; 
  LCD_DB6_DDR |= (1 << LCD_DB6_BIT) ; 
  LCD_DB7_DDR |= (1 << LCD_DB7_BIT) ; 

  // transfer upper nibble first
  LCD_RW_PORT &= ~ (1 << LCD_RW_BIT) ; // we want to write
  if( b & 0x10) {  LCD_DB4_PORT |= (1 << LCD_DB4_BIT) ; } else { LCD_DB4_PORT &= ~ (1 << LCD_DB4_BIT) ; }
  if( b & 0x20) {  LCD_DB5_PORT |= (1 << LCD_DB5_BIT) ; } else { LCD_DB5_PORT &= ~ (1 << LCD_DB5_BIT) ; }
  if( b & 0x40) {  LCD_DB6_PORT |= (1 << LCD_DB6_BIT) ; } else { LCD_DB6_PORT &= ~ (1 << LCD_DB6_BIT) ; }
  if( b & 0x80) {  LCD_DB7_PORT |= (1 << LCD_DB7_BIT) ; } else { LCD_DB7_PORT &= ~ (1 << LCD_DB7_BIT) ; }
  LcdEStrobe() ;

  // transfer lower nibble
  if( b & 0x01) {  LCD_DB4_PORT |= (1 << LCD_DB4_BIT) ; } else { LCD_DB4_PORT &= ~ (1 << LCD_DB4_BIT) ; }
  if( b & 0x02) {  LCD_DB5_PORT |= (1 << LCD_DB5_BIT) ; } else { LCD_DB5_PORT &= ~ (1 << LCD_DB5_BIT) ; }
  if( b & 0x04) {  LCD_DB6_PORT |= (1 << LCD_DB6_BIT) ; } else { LCD_DB6_PORT &= ~ (1 << LCD_DB6_BIT) ; }
  if( b & 0x08) {  LCD_DB7_PORT |= (1 << LCD_DB7_BIT) ; } else { LCD_DB7_PORT &= ~ (1 << LCD_DB7_BIT) ; }
  LcdEStrobe() ;
  }

void LcdWriteInstruction(uint8_t b){
  LCD_RS_PORT &= ~ (1 << LCD_RS_BIT) ; // instruction: RS=0
  LcdWriteByte(b) ;
  }

void LcdWriteData(uint8_t b){
  LCD_RS_PORT |=  (1 << LCD_RS_BIT) ; // data: RS=1
  LcdWriteByte(b) ;
  }

#define LCDMASK 63

uint8_t LcdFifo[64] ;
uint8_t LcdPutIdx ;
uint8_t LcdGetIdx ;

void LcdFifoInit(){
  LcdPutIdx=0 ;
  LcdGetIdx=0 ;
  }

void LcdPutc(char c){
  LcdFifo[LcdPutIdx]=c ;
  LcdPutIdx=(LcdPutIdx+1) & LCDMASK ;
  }

void LcdPutsPgm(const char *progmem_s){
  register char c;
  while ( (c = pgm_read_byte(progmem_s++)) ) { 
    LcdPutc(c); 
	}
  }

//----------------------------------------------------------------------------------------
void SetLcdDirections(){
  LCD_E_DDR   |= (1 << LCD_E_BIT) ; // E line is output from Port to LCD
  LCD_RS_DDR  |= (1 << LCD_RS_BIT) ; // RS line is output from Port to LCD
  LCD_RW_DDR  |= (1 << LCD_RW_BIT) ; // RW line is output from Port to LCD
  LCD_E_PORT  &= ~ (1 << LCD_E_BIT) ; // E line low
  LCD_RW_PORT &= ~ (1 << LCD_E_BIT) ; // RW line low
  
  LCD_DB4_DDR |= (1 << LCD_DB4_BIT) ; 
  LCD_DB5_DDR |= (1 << LCD_DB5_BIT) ; 
  LCD_DB6_DDR |= (1 << LCD_DB6_BIT) ; 
  LCD_DB7_DDR |= (1 << LCD_DB7_BIT) ; 

  }

void delay_ms(uint16_t x){
  uint16_t k ;
  for (k=0 ; k<x ; k++ ) { _delay_loop_2(4000) ; }
  }

void DisplayInit(){
  SetLcdDirections() ;
  delay_ms(100) ;
  LcdWriteInstruction(0x20) ; delay_ms(5) ; // min 4.1ms wait time
  LcdWriteInstruction(0x20) ; delay_ms(1) ; // min 0.1ms wait time
  LcdWriteInstruction(0x28) ; delay_ms(10) ; // dont check BF
 
  LcdWriteInstruction(0x0C) ; delay_ms(1) ; // Display on
  LcdWriteInstruction(0x06) ; delay_ms(1) ; // Entry mode
  LcdWriteInstruction(0x01) ; delay_ms(100) ; // Clear display
 // LcdWriteData('O') ; delay_ms(1) ;
 // LcdWriteData('k') ; delay_ms(1) ;
 // ScrollInit() ;
 // DisplayLines() ;
 // LcdWriteInstruction(0x80+START4) ;delay_ms(1) ;
  LcdFifoInit() ;

}


//----------------------------------------------------------------------------------------

void LCDserve(){
  if (LcdPutIdx != LcdGetIdx) {
	uint8_t c=LcdFifo[LcdGetIdx] ;
	LcdGetIdx=(LcdGetIdx+1) & LCDMASK ;
	if ( c & 0x80 ) { LcdWriteInstruction(c) ; } else { LcdWriteData(c) ; }
	}
  }
